/*
 * Decompiled with CFR 0.152.
 */
package org.python.indexer;

import org.python.indexer.ast.NAttribute;
import org.python.indexer.ast.NName;
import org.python.indexer.ast.NNode;
import org.python.indexer.ast.NStr;

public class Ref {
    private static final int ATTRIBUTE = 1;
    private static final int CALL = 2;
    private static final int NEW = 4;
    private static final int STRING = 8;
    private int start;
    private String file;
    private String name;
    private int flags;

    public Ref(NNode nNode) {
        NNode nNode2;
        if (nNode == null) {
            throw new IllegalArgumentException("null node");
        }
        this.file = nNode.getFile();
        this.start = nNode.start();
        if (nNode instanceof NName) {
            nNode2 = (NName)nNode;
            this.name = nNode2.id;
            if (nNode2.isCall()) {
                this.markAsCall();
            }
        } else if (nNode instanceof NStr) {
            this.markAsString();
            this.name = ((NStr)nNode).n.toString();
        } else {
            throw new IllegalArgumentException("I don't know what " + nNode + " is.");
        }
        nNode2 = nNode.getParent();
        if (nNode2 instanceof NAttribute && nNode == ((NAttribute)nNode2).attr) {
            this.markAsAttribute();
        }
    }

    public Ref(String string, int n, String string2) {
        if (string == null) {
            throw new IllegalArgumentException("'path' cannot be null");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("'text' cannot be null");
        }
        this.file = string;
        this.start = n;
        this.name = string2;
    }

    public String getFile() {
        return this.file;
    }

    public String getName() {
        return this.name;
    }

    public int start() {
        return this.start;
    }

    public int end() {
        return this.start + this.length();
    }

    public int length() {
        return this.isString() ? this.name.length() + 2 : this.name.length();
    }

    public boolean isName() {
        return !this.isString();
    }

    public boolean isAttribute() {
        return (this.flags & 1) != 0;
    }

    public void markAsAttribute() {
        this.flags |= 1;
    }

    public boolean isString() {
        return (this.flags & 8) != 0;
    }

    public void markAsString() {
        this.flags |= 8;
    }

    public boolean isCall() {
        return (this.flags & 2) != 0;
    }

    public void markAsCall() {
        this.flags |= 2;
        this.flags &= 0xFFFFFFFB;
    }

    public boolean isNew() {
        return (this.flags & 4) != 0;
    }

    public void markAsNew() {
        this.flags |= 4;
        this.flags &= 0xFFFFFFFD;
    }

    public boolean isRef() {
        return !this.isCall() && !this.isNew();
    }

    public String toString() {
        return "<Ref:" + this.file + ":" + this.name + ":" + this.start + ">";
    }

    public boolean equals(Object object) {
        if (!(object instanceof Ref)) {
            return false;
        }
        Ref ref = (Ref)object;
        if (this.start != ref.start) {
            return false;
        }
        if (this.name != null ? !this.name.equals(ref.name) : ref.name != null) {
            return false;
        }
        if (this.file != null ? !this.file.equals(ref.file) : ref.file != null) {
            return false;
        }
        return this.flags == ref.flags;
    }

    public int hashCode() {
        return ("" + this.file + this.name + this.start).hashCode();
    }
}

